<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Dealer;
use Auth;
class DealerController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $dealers = Dealer::get();
        return view('Admin.dealer.index', compact('dealers'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('Admin.dealer.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
		//dd($request->all());
        $validatedData = $request->validate([
            'name' => 'required',
            'type' => 'required',
            'details' => 'required',
            'status' => 'required',
			'file' => 'required|file|mimes:jpeg,png,jpg|max:1024'
        ]);
		 if ($request->hasFile('file')) {
			$file = $request->file('file');
			$filename = rand().'.'.$file->getClientOriginalExtension();
			$file->move(public_path().'/dealer/', $filename); 
		 }
		 $admin_id = Auth::guard('admin')->user()->id;
        $data = new Dealer();
        $data->admin_id = $admin_id;
        $data->name = $request->name;
        $data->image = $filename;
        $data->type = $request->type;
        $data->phone = $request->phone;
        $data->details = $request->details;
        $data->address = $request->address;
        $data->status = $request->status;
        $data->save();

        $notification = array(
            'messege'   => 'Save Successfull',
            'alert-type' => 'success'
        );
        return redirect()->back()->with($notification);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = Dealer::findOrFail($id);
        return view('Admin.dealer.edit', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
       
        $validatedData = $request->validate([
            'name' => 'required',
            'type' => 'required',
            'details' => 'required',
            'status' => 'required',
        ]);
		
		 if ($request->hasFile('file')) {
			 $oldfile= public_path().'/dealer/'.$request->oldfile;
			 if(file_exists($oldfile)){
				 unlink($oldfile);
			 }
			$file = $request->file('file');
			$filename = rand().'.'.$file->getClientOriginalExtension();
			$file->move(public_path().'/dealer/', $filename); 
		 }else{
			$filename = $request->oldfile;
		 }
		$admin_id = Auth::guard('admin')->user()->id;
        $data = Dealer::findOrFail($id);
        $data->admin_id = $admin_id;
        $data->name = $request->name;
        $data->image = $filename;
        $data->type = $request->type;
        $data->phone = $request->phone;
        $data->details = $request->details;
        $data->address = $request->address;
        $data->status = $request->status;
        $data->save();

        $notification = array(
            'messege'   => 'Update Successfull',
            'alert-type' => 'success'
        );
        return redirect()->back()->with($notification);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data = Dealer::findOrFail($id);
		 $oldfile= public_path().'/dealer/'.$data->image;
			 if(file_exists($oldfile)){
				 unlink($oldfile);
			 }
        $data->delete();

        $notification = array(
            'messege'   => 'Deleted Successfull',
            'alert-type' => 'error'
        );
        return redirect()->back()->with($notification);
    }
}
