@extends('User.layouts.master')
@section('body')



<div class="col-md-12">
	<div class="container-fluid padd">
		<div class="row">


			<div class="col-xl-3 col-lg-3 col-md-4 col-sm-12 col-12 mt-4 sidebar">
				@include('User.Guest.user-sidebar')
			</div>


			<div class="col-xl-9 col-lg-9 col-md-8 col-sm-12 col-12 mt-4">
				<div class="col-md-12 p-4 userdashboard">
					@if(Auth('guest')->user()->rank=='Dealer')
						<button class="btn btn-success text-right" id="save_value"> Summary</button>
						<form action="{{ url('/invoice-summary') }}" method="POST" id="summary" target="_blank">
							@csrf
							<input type="hidden" name="invoice_id"  id="invoice_id">
						</form>
					@endif
					<strong>All Orders</strong><br><br>

					<div class="table-responsive">
						<table id="example" class="table table-bordered table-striped">
							<thead>
								<tr>
									<th>Order</th>
									<th>Invoice</th>
									@if(Auth('guest')->user()->rank=='Dealer')
										<th>Dealer Invoice</th>
									@endif
									<th>Order Date</th>
									<th>Ammount</th>
									<th>Payment</th>
									<th>Status</th>
								</tr>
							</thead>


							<tbody>

								@if($data)
								@foreach($data as $showdata)

								<tr>
									<td>#{{ $showdata->invoice_id }}</td>
									<td><a href="{{ url('/viewinvoice/'.$showdata->session_id) }}" class="btn btn-warning btn-sm" target="_blank">Customer View</a></td>
									@if(Auth('guest')->user()->rank=='Dealer')
									<td align="center">
										<input type="checkbox" name="invoice[]" class="invoice" value="{{ $showdata->invoice_id }}">
										<br>
										<a href="{{url('invoice-paper-dealer')}}/{{$showdata->session_id}}" class="btn btn-success btn-sm" target="_blank">Dealer View</a>	
									</td>
									@endif
									<td>{{ $showdata->created_at }}</td>

									<td>&#2547; {{ $showdata->grand_total }}</td>
									<td>{{ $showdata->payment_type }}</td>
									@if($showdata->status == 0)
									<td><span class="orderstatus bg-info">Pending</span></td>
									@elseif($showdata->status==1)
									<td><span class="orderstatus bg-info">Processing</span></td>
									@elseif($showdata->status==5)
									<td><span class="orderstatus bg-dark">Shipping</span></td>
									@elseif($showdata->status==2)
									<td><span class="orderstatus bg-warning">On the way</span></td>
									@elseif($showdata->status==3)
									<td><span class="orderstatus bg-success">Complete</span></td>
									@elseif($showdata->status==6)
									<td><span class="orderstatus bg-warning">Refound</span></td>
									@elseif($showdata->status==4)
									<td><span class="orderstatus bg-danger">Reject</span></td>

									@else
									<td><span class="orderstatus bg-danger">Failed</span></td>
									@endif
								</tr>

								@endforeach
								@endif

							</tbody>


						</table>
					</div>



				</div>
			</div>







		</div>
	</div>
</div><!------------End Dashboard-------------->


@endsection