@extends('User.layouts.master')
@section('meta_og')
 <!-- Open Graph data -->
    <meta property="og:title" content="{{ strip_tags($data->name) }}" />
    <meta property="og:type" content="og:product" />
    <meta property="og:url" content="{{ url()->full()}}" />
    <meta property="og:image" content="{{ asset('public/dealer') }}/{{ $data->image }}" />
    <meta property="og:description" content="{{ strip_tags($data->details)}}" />
    <meta property="og:site_name" content="Trusted eCommerce Site: আমাদের ডিলার:PaikariSale" />
@endsection
@section('body')

<div class="col-md-12">
	<div class="container-fluid">
		<div class="row">

			<div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-3 d-none d-lg-block"> 
				@include('User.layouts.sidmenu')
			</div><!----------End Sidebar-------->

			<div class="col-xl-9 col-lg-9 col-md-12 col-sm-12 col-12 pb-5">

				<div class="col-md-12 detailspage mt-4 p-4">
					<strong>আমাদের ডিলারগণ</strong><br><br>
					<img class="product-image"  src="{{ asset('public/dealer') }}/{{ $data->image }}" >
					<br>
					<strong>{!! str_replace("*",'<br>',$data->name) !!}</strong><br>
					<a href="https://www.facebook.com/sharer/sharer.php?u={{ url()->full()}}" target="_blank"><div class="mt-2"><button class="btn btn-primary btn-sm" >Share On Facebook</button></div></a>
					<hr>
					<span>
						{{ $data->phone??'' }}
					</span>
					<span>
						{{ $data->address??'' }}
					</span>
					<span>
						{!! $data->details !!}
					</span>
				</div>




			</div>

			
		</div>
	</div>
</div>




@endsection