@extends('User.layouts.master')
@section('body')

<style>
  .category_wrapper {
    display: grid;
    grid-template-columns: repeat(6, 1fr);
    grid-gap: 10px;
    padding: 0;
  }

  .category_item {
    width: fclose;
    padding: 6px;
    border: 1px solid #e1e1e1;
    border-radius: 5px;
    cursor: pointer;
    display: flex;
    flex-direction: column;
    align-items: center;
    font-size: 13px;
  }

  @media (max-width: 992px) {
    .category_wrapper {
      grid-template-columns: repeat(4, 1fr);
    }
    .product-image{
    /*   height:120px!important; */
    }
  }
  @media (min-width: 992px) {
    .main-bar{
      width:79%!important;
    }
    .side-bar{
      width:21%!important;
    }
    .product-image{

    }
  }
  @media (max-width: 768px) {
    .category_wrapper {
      grid-template-columns: repeat(2, 1fr);
    }
  }
</style>


@php

$activeslider = DB::table('sliders')->orderBy('id','DESC')->first();
$slidermore = DB::table('sliders')->orderBy('id','DESC')->skip(1)->limit(2)->get();

@endphp



<div class="col-md-12">
  <div class="container-fluid">
    <div class="row g-2">


      <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-3 d-none d-lg-block side-bar"">
        @include('User.layouts.sidmenu')
      </div>
      <!----------End Sidebar-------->

      <div class="col-xl-9 col-lg-9 col-md-12 col-sm-12 col-12 main-bar">

        <div class="bg-warning breakingnews col-md-12 mt-2 p-2 pb-0 rounded text-light" >
          <marquee scrollamount="4" onmouseover="this.stop();" onmouseout="this.start();">
            <b>{{$settings->marque ?? ''}}</b>
          </marquee>
        </div>
        <!---------End Breaking--------->


        <!----------- for desktop version ---------->
        <div class="col-md-12 pt-2 d-none d-sm-block" >
          <div id="carouselExampleFade" class="carousel slide carousel-fade" data-bs-ride="carousel">
            <div class="carousel-inner">
              <div class="carousel-item active">
                <a href="{{ $activeslider->url }}">
                  <img class="d-block w-100 rounded" src="{{ asset('public/sliderImage') }}/{{ $activeslider->image }}" id="sliderimage" style="aspect-ratio: 2/.7;">
                </a>
              </div>
              @if (isset($slidermore))
              @foreach ($slidermore as $slidermoredata)
              <div class="carousel-item">
                <a href="{{ $slidermoredata->url }}">
                  <img src="{{ asset('public/sliderImage') }}/{{ $slidermoredata->image }}" class="d-block w-100 rounded" style="aspect-ratio: 2/.7;">
                </a>
              </div>
              @endforeach
              @endif

            </div>
            <button class="carousel-control-prev" type="button" data-bs-target="#carouselExampleFade" data-bs-slide="prev">
              <span class="carousel-control-prev-icon" aria-hidden="true"></span>
              <span class="visually-hidden">Previous</span>
            </button>
            <button class="carousel-control-next" type="button" data-bs-target="#carouselExampleFade" data-bs-slide="next">
              <span class="carousel-control-next-icon" aria-hidden="true"></span>
              <span class="visually-hidden">Next</span>
            </button>
          </div>


        </div>
        <!-----End Slider------->
        
      




        <!-- <div class="col-md-12 categorys mt-5">
          <div class="head mb-4">
            <strong>Browse all categories</strong>
          </div>

          <div class="uk-position-relative uk-visible-toggle w-100 uk-light bg-white p-4 rounded" tabindex="-1" uk-slider>
            <ul class="uk-slider-items uk-child-width-1-2 uk-child-width-1-6@m uk-grid">

              @php
              $item = DB::table('product_item')->orderBy('sl','ASC')->get();
              @endphp

              @if(isset($item))
              @foreach($item as $i)
              @php
              $item_name=str_replace(" ","-",$i->item_name)
              @endphp
              <li>
                <div class="uk-panel">
                  <center>
                    <a href="{{url('item')}}/{{$item_name}}/{{$i->id}}">
                      @if($i->image == !NULL)
                      <img src="{{ asset('/itemImage') }}/{{ $i->image }}" class="img-fluid" style="height:50px;">
                      @else
                      <img src="{{ asset('/fontdev/') }}/img/demo.jpg" class="img-fluid">
                      @endif

                    </a>
                    <div class="text-dark fw-bold">{{ $i->item_name}}</div>
                  </center>
                </div>
              </li>

              @endforeach
              @endif


            </ul>

            <a class="uk-position-center-left uk-position-small bg-light text-dark rounded p-2" href="#" uk-slidenav-previous uk-slider-item="previous"></a>
            <a class="uk-position-center-right uk-position-small bg-light text-dark rounded p-2" href="#" uk-slidenav-next uk-slider-item="next"></a>

          </div>

        </div> -->

        <!-- Start Zakaria Code -->
        <div class="col-md-12 categorys mt-5">
          <div class="head text-center mb-2 ">
            <strong>All <span style="color:red;">Categories</span></strong>
          </div>
          <div class="title-border"></div>

          <div class="">
            <ul class=" category_wrapper">

             
              @if(isset($item))
              @foreach($item as $i)
              @php
              $item_name=str_replace(" ","-",$i->item_name)
              @endphp
              <li class="category_item" style="list-style-type: none;">
                <a href="{{url('item')}}/{{$item_name}}/{{$i->id}}" class="w-100">
                  @if($i->image == !NULL)
                  <img src="{{ asset('public/itemImage') }}/{{ $i->image }}" class="img-fluid w-100" style="aspect-ratio: 1/1;">
                  @else
                  <img src="{{ asset('public/fontdev/') }}/img/demo.jpg" class="img-fluid w-100">
                  @endif
                </a>

                <a href="{{url('item')}}/{{$item_name}}/{{$i->id}}"><div class="text-dark fw-normal mt-2">{{ $i->item_name}}</div></a>
              </li>

              @endforeach
              @endif


            </ul>



          </div>

        </div>
        <!-- End Zakaria Code -->



        <!---------End Category--------->


        <!-- @php
        $offerbanner = DB::table('explore_banners')->limit(4)->get();
        @endphp


        <div class="col-md-12 mt-4">
          <div class="row">

            @if(isset($offerbanner))
            @foreach($offerbanner as $offer)

            <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-3">
              <a href="{{ $offer->url }}"><img src="{{ asset('public/exploreImage') }}/{{ $offer->image }}" class="img-fluid"></a>
            </div>

            @endforeach
            @endif

          </div>
        </div> -->
        <!---------End Offer Banner--------->





        <div class="col-md-12 mt-5">
          <div class="head text-center underlined-border">
            <strong>Our <span style="color:red;">Products</span></strong>
          </div>
          <div class="title-border"></div>


          <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 pb-5">


            <div class="col-md-12">
              <div class="scrolling-pagination">
                <div class="row g-2">



                  @foreach($all_prducts as $p)
                  @php
                  $productname=str_replace(["%","/"," "],"-", $p->product_name)
                  @endphp
                  

                  <div class="col-xl-2 col-lg-3 col-md-3 col-sm-4 col-6">
                    <div class=" product p-2" style=" height: auto!important;">
                      <center style="width: 100%;">


                         <a href="{{ url('product') }}/{{ $productname }}/{{ $p->product_id }}" class="text-dark fw-bold productname mt-3 d-block text-center">


                          <img class="product-image"  src="{{ asset('public/productImage') }}/{{ $p->image }}" 

                          alt="">

                       

                          <span style="color: black; font-size: 14px;display: block;padding-top:15px;line-height: 17px;padding-bottom:15px; font-weight:normal;">
                            {{ $p->product_name }}
                          </span>

                          <span class="text-dark" style="font-size: 14px; font-weight: 500 !important">{{$p->product_weight}}</span> <br>


                          <span class="p_curency">৳ {{ number_format($p->sale_price, 2, '.', ',')  }}</span>
                         <!--<span class="p_curency">৳ {{ intval($p->current_price) }}</span>
                          @if ($p->discount_price > 0)
                          <del>৳ {{ number_format($p->sale_price, 2, '.', ',') }}</del>
                          @endif-->

                        </a>
                        <div class="mt-2"><button class="btn btn-success btn-sm" onclick="AddCart('{{ $p->id }}')">Add To Bag</button></div>
                      </center>
                    </div>
                  </div>


                  @endforeach






                </div>

              </div>
            </div>

          </div>

        </div>
        <!------------End Popular Products---------->





        <br>
        <br>




      </div>

    </div>
  </div>
</div>

<style>
  .footermenu li {
    display: inline-block;
    padding-right: 10px;
    padding-left: 10px;
    border-right: 1px solid gray;

  }

  .footermenu li a {
    color: gray;
    font-size: 14px;
  }
</style>





@endsection